#!/usr/bin/env python
# coding: utf-8

from ECD_aMCI import *

# Simulation experiment on simulated data
# Define simulation experiment settings
config = {
    # Data generation parameters
    'dim': 10,                     # Number of variables in the system
    'tau_true': 5,                 # True maximum time lag in data generation
    'auto_coeff': 0.9,             # Autoregressive coefficient (must be between -1 and 1 for stability)
    'cross_coeff': 0.2,            # Cross-effect coefficient between variables
    'instant_ratio': 1,            # Base number of instantaneous connections
    'delay_cross_x': 1.5,          # Base number of delayed cross connections
    'func': np.copy,               # Function to transform causal relationships (np.copy for linear)
    'T': 500,                      # Time series length
    'B': 300,                     # Number of the simulated datasets
    #algorithm parameters
    'Method': 1,                   # Method selection (0: PCMCI+, 1: ECD-aMCI, 2： NTS-NOTEARS, 3: Bagged-PCMCI+)
    'pc_alpha': 0.01,             # Significance level for PC algorithm
    'tau_max': 5,                  # Maximum time lag to consider
    'tau_min': 0,                  # Minimum time lag to consider
    'cond_ind_test': ParCorr(),    # Conditional independence test (ParCorr for linear)
}

# Run parallel experiments using available CPU cores
num_cores = multiprocessing.cpu_count() - 2  # Leave 2 cores free
results_and_times_and_graphs = Parallel(n_jobs=num_cores)(
    delayed(run_single_experiment)(
        dim=config['dim'],
        auto_coeff=config['auto_coeff'],
        cross_coeff=config['cross_coeff'],
        seed=b,  # Using bootstrap index as random seed
        instant_ratio=config['instant_ratio'],
        delay_cross_x=config['delay_cross_x'],
        func=config['func'],
        T=config['T'],
        tau_min=config['tau_min'],
        tau_true=config['tau_true'],
        tau_max=config['tau_max'],
        Method=config['Method'],
        cond_ind_test=config['cond_ind_test'],
        pc_alpha=config['pc_alpha'],
    )
    for b in range(config['B'])  # Run B experiments
)
print_metrics(results_and_times_and_graphs, config)

